<?php
require_once 'config/config.php';

// التحقق من تسجيل الدخول
if (!isset($_SESSION['user_id'])) {
    header("Location: auth/login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// الإعدادات
$limit = 25;
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$offset = ($page - 1) * $limit;

// استعلام البيانات
$query = "SELECT * FROM requests ORDER BY id DESC LIMIT $limit OFFSET $offset";
$count_query = "SELECT COUNT(*) as total FROM requests";

$result = $conn->query($query);
$total_result = $conn->query($count_query);
$total = $total_result->fetch_assoc()['total'];
$total_pages = ceil($total / $limit);
?>

<?php include 'header.php'; ?>

<div class="main-content p-4" style="flex: 1;">

<h2 class="mb-4">📋 جميع الطلبات</h2>

<!-- مربع البحث -->
<input type="text" id="search" class="form-control mb-3" placeholder="ابحث...">

<?php if ($result && $result->num_rows > 0): ?>
    <div class="table-responsive">
        <table class="table table-bordered table-striped align-middle text-center">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>اسم العميل</th>
                    <th>الموبايل</th>
                    <th>الإيميل</th>
                    <th>نوع الرحلة</th>
                    <th>الرحلة المطلوبة</th>
                    <th>مدة الرحلة</th>
                    <th>فنادق مكة</th>
                    <th>فنادق المدينة</th>
                    <th>عدد الأشخاص</th>
                    <th>أنواع الغرف</th>
                    <th>ملاحظات</th>
                    <th>تاريخ الإدخال</th>
                    <th>الإجراءات</th>
                </tr>
            </thead>
            <tbody id="requests-body">
                <?php while ($req = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= $req['id'] ?></td>
                        <td><?= htmlspecialchars($req['client_name']) ?></td>
                        <td><?= htmlspecialchars($req['mobile']) ?></td>
                        <td><?= htmlspecialchars($req['email']) ?></td>
                        <td><?= htmlspecialchars($req['trip_type']) ?></td>
                        <td><?= htmlspecialchars($req['trip_place']) ?></td>
                        <td><?= htmlspecialchars($req['trip_duration']) ?></td>
                        <td><?= htmlspecialchars($req['hotel_makkah']) ?></td>
                        <td><?= htmlspecialchars($req['hotel_madina']) ?></td>
                        <td><?= htmlspecialchars($req['persons_count']) ?></td>
                        <td><?= htmlspecialchars($req['room_types']) ?></td>
                        <td><?= nl2br(htmlspecialchars($req['notes'])) ?></td>
                        <td><?= $req['created_at'] ?? '-' ?></td>
                        <td>
                            <a href="request_pdf.php?id=<?= $req['id'] ?>" class="btn btn-sm btn-primary" target="_blank">📄 PDF</a>
                            <a href="request_delete.php?id=<?= $req['id'] ?>" 
                               onclick="return confirm('هل أنت متأكد من الحذف؟');" 
                               class="btn btn-sm btn-danger">🗑 حذف</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>

    <!-- ترقيم الصفحات -->
    <?php if ($total_pages > 1): ?>
    <form method="get" class="mt-3 d-flex align-items-center gap-2 flex-wrap">
        <button type="submit" name="page" value="1" class="btn btn-outline-primary btn-sm" <?= $page == 1 ? 'disabled' : '' ?>>
            &laquo; الأولى
        </button>
        <button type="submit" name="page" value="<?= max(1, $page - 1) ?>" class="btn btn-outline-primary btn-sm" <?= $page == 1 ? 'disabled' : '' ?>>
            &lsaquo; السابق
        </button>
        <label for="page-select" class="mb-0">صفحة:</label>
        <select name="page" id="page-select" onchange="this.form.submit()" class="form-select form-select-sm w-auto d-inline-block">
            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                <option value="<?= $i ?>" <?= $i == $page ? 'selected' : '' ?>><?= $i ?></option>
            <?php endfor; ?>
        </select>
        <button type="submit" name="page" value="<?= min($total_pages, $page + 1) ?>" class="btn btn-outline-primary btn-sm" <?= $page == $total_pages ? 'disabled' : '' ?>>
            التالي &rsaquo;
        </button>
        <button type="submit" name="page" value="<?= $total_pages ?>" class="btn btn-outline-primary btn-sm" <?= $page == $total_pages ? 'disabled' : '' ?>>
            الأخيرة &raquo;
        </button>
    </form>
    <?php endif; ?>

<?php else: ?>
    <div class="alert alert-info">لا توجد طلبات حالياً.</div>
<?php endif; ?>
</div> <!-- Close main-content -->

<?php include 'includes/footer.php'; ?>

<script>
// البحث عبر أجاكس (مستقبلي)
document.getElementById('search').addEventListener('input', function() {
    let keyword = this.value;
    fetch('search_requests.php?q=' + encodeURIComponent(keyword))
        .then(res => res.text())
        .then(data => {
            document.getElementById('requests-body').innerHTML = data;
        });
});
</script>
