<?php
require_once 'config/config.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    echo json_encode(["success" => false, "error" => "Not authorized"]);
    exit;
}

$id     = intval($_POST['id']);
$status = $_POST['status'] ?? null;
$issue_date = $_POST['issue_date'] ?? null;

if (!$id || !$status) {
    echo json_encode(["success" => false, "error" => "Invalid parameters"]);
    exit;
}

if ($status === "issued") {
    $stmt = $conn->prepare("UPDATE transit_visas SET issued = 1, issue_date = ? WHERE id = ?");
    $stmt->bind_param("si", $issue_date, $id);
} else {
    $stmt = $conn->prepare("UPDATE transit_visas SET status = ? WHERE id = ?");
    $stmt->bind_param("si", $status, $id);
}

if ($stmt->execute()) {
    echo json_encode(["success" => true]);
} else {
    echo json_encode(["success" => false, "error" => $stmt->error]);
}
