<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require '../config.php';
require __DIR__ . '/../vendor/autoload.php';

use Mpdf\Mpdf;

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

if (!isset($_GET['id'])) {
    die("طلب غير صحيح.");
}

$id = intval($_GET['id']);
$stmt = $pdo->prepare("SELECT * FROM requests WHERE id = ?");
$stmt->execute([$id]);
$request = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$request) {
    die("الطلب غير موجود.");
}

// تجهيز التاريخ فقط (بدون الوقت)
$date = '';
if (!empty($request['created_at'])) {
    $date = date('Y-m-d', strtotime($request['created_at']));
}

$mpdf = new Mpdf([
    'mode' => 'utf-8',
    'format' => 'A4',
    'directionality' => 'rtl',
    'default_font' => 'dejavusans',
    'margin_top' => 0,    
    'margin_left' => 0,
    'margin_right' => 0,
    'margin_bottom' => 10
]);

$html = "
<style>
    body { font-family: 'dejavusans'; font-size:14px; margin:0; padding:0; }
    h2 { color:#198754; text-align:center; margin:15px 0; }
    .header { margin:0; padding:0; }
    .header img { width:100%; height:auto; display:block; margin:0; padding:0; }

    /* الجداول بمسافة من الجوانب */
    .table-container { 
        margin-left: 10mm; 
        margin-right: 10mm; 
        margin-top: 0; 
    }
    table { width:100%; border-collapse:collapse; margin-top:15px; }
    th, td { border:1px solid #999; padding:8px 10px; font-size:14px; }
    th { background:#f2f2f2; text-align:right; width:35%; }
    td { text-align:left; width:65%; }
</style>

<div class='header'>
    <img src='../images/header.png'>
</div>

<div class='table-container'>
<h2>طلب رحلة عمرة</h2>

<table>
  <tr><th>اسم العميل</th><td>{$request['client_name']}</td></tr>
  
  
  <tr><th>الموبايل</th><td>{$request['mobile']}</td></tr>
  <tr><th>الإيميل</th><td>{$request['email']}</td></tr>
  <tr><th>نوع الرحلة</th><td>{$request['trip_type']}</td></tr>
  <tr><th>الرحلة المطلوبة</th><td>{$request['trip_place']}</td></tr>
  <tr><th>مدة الرحلة</th><td>{$request['trip_duration']}</td></tr>
  <tr><th>فنادق مكة</th><td>{$request['hotel_makkah']}</td></tr>
  <tr><th>فنادق المدينة</th><td>{$request['hotel_madina']}</td></tr>
  <tr><th>عدد الأشخاص</th><td>{$request['persons_count']}</td></tr>
  <tr><th>أنواع الغرف</th><td>{$request['room_types']}</td></tr>
  <tr><th>ملاحظات</th><td>".nl2br($request['notes'])."</td></tr>";

if ($date) {
    $html .= "<tr><th>تاريخ الإدخال</th><td>{$date}</td></tr>";
}

$html .= "</table></div>";


$mpdf->WriteHTML($html);
$mpdf->Output("request_$id.pdf", 'I');
