<?php
require_once __DIR__ . '/config/config.php';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (isset($_GET['lang']) && in_array($_GET['lang'], ['english', 'arabic'])) {
    $_SESSION['language'] = $_GET['lang'];
    header("Location: ".$_SERVER['PHP_SELF']);
    exit;
}

$user_id = $_SESSION['user_id'] ?? null;
$user_name = $_SESSION['user_name'] ?? '';
$lang_code = $_SESSION['language'] ?? 'english';
require_once "languages/$lang_code.php";

$current = basename($_SERVER['PHP_SELF']);
?>

<!DOCTYPE html>
<html lang="<?= $lang_code ?>">
<head>
    <meta charset="UTF-8">
    <title><?= $lang['main'] ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap CSS & Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        body {
            display: flex;
            margin: 0;
            background-color: #f8f9fa;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .sidebar {
            width: 250px;
            background-color: #212529;
            min-height: 100vh;
            padding: 20px 15px;
            box-shadow: 2px 0 5px rgba(0,0,0,0.1);
        }

        .sidebar img.logo {
            display: block;
            margin: 0 auto 20px auto;
            width: 200px;
            height: auto;
        }

        .user-info {
            color: #f8f9fa;
            text-align: center;
            font-weight: 600;
            margin-bottom: 30px;
            font-size: 1rem;
        }

        .sidebar button,
        .sidebar a {
            display: flex;
            align-items: center;
            gap: 10px;
            width: 100%;
            padding: 14px 18px;
            border: none;
            background-color: #343a40;
            color: #dee2e6;
            text-align: left;
            border-radius: 8px;
            font-size: 1rem;
            margin-bottom: 6px;
            text-decoration: none;
            transition: all 0.2s ease-in-out;
        }

        .sidebar button:hover,
        .sidebar a:hover {
            background-color: #495057;
            color: #ffffff;
            transform: translateX(4px);
            text-decoration: none;
        }

        .sidebar .submenu a {
            padding-left: 36px;
            font-size: 0.95rem;
            color: #adb5bd;
            text-decoration: none;
            border-radius: 6px;
        }

        .sidebar .submenu a:hover {
            background-color: #6c757d;
            color: #ffffff;
        }

        .submenu a.active-link {
            background-color: #0d6efd;
            color: white !important;
            font-weight: bold;
        }

        .sidebar .text-danger {
            color: #e74c3c !important;
        }

        .sidebar .text-danger:hover {
            background-color: #c0392b;
            color: white !important;
        }

        .lang-switch {
            color: #adb5bd;
            text-decoration: none;
            font-size: 0.85rem;
            display: inline-block;
            margin-bottom: 10px;
        }

        .lang-switch:hover {
            color: #ffffff;
            text-decoration: underline;
        }
        
        
        
        
        .submenu a {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 10px 15px;
    margin-bottom: 5px;
    font-size: 0.95rem;
    color: #adb5bd;
    text-decoration: none;
    border-radius: 6px;
}

.submenu a:hover {
    background-color: #6c757d;
    color: white;
}

.submenu a.active-link {
    background-color: #0d6efd;
    color: white !important;
    font-weight: bold;
}

        @media (max-width: 768px) {
    .sidebar {
    display: none !important;
    width: 0 !important;
    padding: 0 !important;    }
body {
    flex-direction: column !important;
}

}

    </style>
</head>
<body>
<!-- Navbar for mobile -->
<nav class="navbar navbar-dark bg-dark d-md-none w-100">
    <div class="container-fluid">
        <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#mobileSidebar" aria-controls="mobileSidebar">
            <span class="navbar-toggler-icon"></span>
        </button>
        <span class="navbar-brand mb-0 h1"><?= $lang['main'] ?></span>
    </div>
</nav>

<div class="sidebar d-none d-md-block">
    <div class="text-center mb-3">
        <a href="?lang=<?= $lang_code === 'arabic' ? 'english' : 'arabic' ?>" class="lang-switch">
            🌐 <?= $lang_code === 'arabic' ? 'English' : 'العربية' ?>
        </a>
    </div>

    <img src="images/logo.png" alt="Logo" class="logo">
    <div class="user-info"><?= htmlspecialchars($user_name) ?></div>
<!-- STATISTICS -->
<button class="btn text-start text-white mb-2" onclick="location.href='main.php'">
    <i class="bi bi-bar-chart-line-fill"></i> <?= $lang['statistics'] ?? 'Statistics' ?>
</button>

    <!-- SYSTEM -->
    <button class="btn text-start text-white" data-bs-toggle="collapse" data-bs-target="#systemMenu" aria-expanded="<?= in_array($current, ['view_voucher.php', 'index.php', 'edit_terms.php']) ? 'true' : 'false' ?>">
        <i class="bi bi-gear-fill"></i> <?= $lang['system'] ?>
    </button>
    <div class="collapse <?= in_array($current, ['view_voucher.php', 'index.php', 'edit_terms.php']) ? 'show' : '' ?>" id="systemMenu">
        <div class="submenu">
            <a href="view_voucher.php" class="<?= $current == 'view_voucher.php' ? 'active-link' : '' ?>"><i class="bi bi-speedometer2"></i> <?= $lang['view_vouchers'] ?></a>
            <a href="index.php" class="<?= $current == 'index.php' ? 'active-link' : '' ?>"><i class="bi bi-plus-square"></i> <?= $lang['add_voucher'] ?></a>
            <?php if ($user_id == 1): ?>
                <a href="edit_terms.php" class="<?= $current == 'edit_terms.php' ? 'active-link' : '' ?>"><i class="bi bi-pencil-square"></i> <?= $lang['edit_terms'] ?></a>
            <?php endif; ?>
        </div>
    </div>


<!-- FOLLOW UP -->
<button class="btn text-start text-white mt-2" data-bs-toggle="collapse" data-bs-target="#followupMenu" aria-expanded="<?= in_array($current, ['view_customers.php', 'add_customer.php']) ? 'true' : 'false' ?>">
    <i class="bi bi-journal-text"></i> <?= $lang['follow_up'] ?>
</button>
<div class="collapse <?= in_array($current, ['view_customers.php', 'add_customer.php']) ? 'show' : '' ?>" id="followupMenu">
    <div class="submenu">
        <a href="view_customers.php" class="<?= $current == 'view_customers.php' ? 'active-link' : '' ?>"><i class="bi bi-list-ul"></i> <?= $lang['view_customers'] ?></a>
        <a href="add_customer.php" class="<?= $current == 'add_customer.php' ? 'active-link' : '' ?>"><i class="bi bi-person-plus"></i> <?= $lang['add_customer'] ?></a>
    </div>
</div>




<!-- TRANSIT VISA FOLLOW UP -->

    <?php if (in_array($user_id, [1, 2])): ?>

<button class="btn text-start text-white mt-2" data-bs-toggle="collapse" data-bs-target="#transitVisaMenu" aria-expanded="<?= in_array($current, ['view_transit_visas.php', 'add_transit_visa.php', 'completed_transit_visas.php']) ? 'true' : 'false' ?>">
    <i class="bi bi-passport"></i> <?= $lang['transit_visas_followup'] ?>
</button>
<div class="collapse <?= in_array($current, ['view_transit_visas.php', 'add_transit_visa.php', 'completed_transit_visas.php']) ? 'show' : '' ?>" id="transitVisaMenu">
    <div class="submenu">
        <a href="view_transit_visas.php" class="<?= $current == 'view_transit_visas.php' ? 'active-link' : '' ?>">
            <i class="bi bi-list-check"></i> <?= $lang['transit_visas_followup'] ?>
        </a>
        <a href="add_transit_visa.php" class="<?= $current == 'add_transit_visa.php' ? 'active-link' : '' ?>">
            <i class="bi bi-plus-circle"></i> <?= $lang['add_transit_visa'] ?>
        </a>
        <a href="completed_transit_visas.php" class="<?= $current == 'completed_transit_visas.php' ? 'active-link' : '' ?>">
            <i class="bi bi-check2-all"></i> <?= $lang['completed_bookings'] ?>
        </a>
    </div>
</div>
    <?php endif; ?>


<!-- QUOTE SECTION -->

<?php if (in_array($user_id, [1, 2])): ?>

<button class="btn text-start text-white mt-2" data-bs-toggle="collapse" data-bs-target="#quoteMenu" aria-expanded="<?= in_array($current, ['view_quotes.php', 'add_quote.php', 'completed_quotes.php']) ? 'true' : 'false' ?>">
    <i class="bi bi-file-earmark-text"></i> <?= $lang['quotes'] ?>
</button>
<div class="collapse <?= in_array($current, ['view_quotes.php', 'add_quote.php', 'completed_quotes.php']) ? 'show' : '' ?>" id="quoteMenu">
    <div class="submenu">
        <a href="view_quotes.php" class="<?= $current == 'view_quotes.php' ? 'active-link' : '' ?>">
            <i class="bi bi-list-check"></i> <?= $lang['quotes'] ?>
        </a>
        <a href="add_quote.php" class="<?= $current == 'add_quote.php' ? 'active-link' : '' ?>">
            <i class="bi bi-plus-circle"></i> <?= $lang['add_quote'] ?>
        </a>
        <a href="completed_quotes.php" class="<?= $current == 'completed_quotes.php' ? 'active-link' : '' ?>">
            <i class="bi bi-check2-all"></i> <?= $lang['completed_quotes'] ?>
        </a>
    </div>
</div>

<?php endif; ?>


<!-- FLIGHT DETAILS -->
<button class="btn text-start text-white mt-2" data-bs-toggle="collapse" data-bs-target="#flightMenu" aria-expanded="<?= in_array($current, ['add_flight_details.php', 'view_flight_details.php']) ? 'true' : 'false' ?>">
    <i class="bi bi-airplane"></i> <?= $lang['flight_details'] ?>
</button>
<div class="collapse <?= in_array($current, ['add_flight_details.php', 'view_flight_details.php']) ? 'show' : '' ?>" id="flightMenu">
    <div class="submenu">
        <a href="add_flight_details.php" class="<?= $current == 'add_flight_details.php' ? 'active-link' : '' ?>">
            <i class="bi bi-plus-circle"></i> <?= $lang['add_flight_details'] ?>
        </a>
        <a href="view_flight_details.php" class="<?= $current == 'view_flight_details.php' ? 'active-link' : '' ?>">
            <i class="bi bi-list-ul"></i> <?= $lang['view_flight_details'] ?>
        </a>
    </div>
</div>


    <!-- USERS -->
    <?php if (in_array($user_id, [1, 2])): ?>
        <button class="btn text-start text-white mt-2" data-bs-toggle="collapse" data-bs-target="#userMenu" aria-expanded="<?= in_array($current, ['users.php', 'add_user.php']) ? 'true' : 'false' ?>">
            <i class="bi bi-people-fill"></i> <?= $lang['users'] ?>
        </button>
        <div class="collapse <?= in_array($current, ['users.php', 'add_user.php']) ? 'show' : '' ?>" id="userMenu">
            <div class="submenu">
                <a href="users.php" class="<?= $current == 'users.php' ? 'active-link' : '' ?>"><i class="bi bi-person-lines-fill"></i> <?= $lang['view_users'] ?></a>
                <a href="add_user.php" class="<?= $current == 'add_user.php' ? 'active-link' : '' ?>"><i class="bi bi-person-plus-fill"></i> <?= $lang['add_user'] ?></a>
            </div>
        </div>
    <?php endif; ?>

    <!-- ACCOUNT -->
    <button class="btn text-start text-white mt-2" data-bs-toggle="collapse" data-bs-target="#accountMenu" aria-expanded="<?= in_array($current, ['change_password.php']) ? 'true' : 'false' ?>">
        <i class="bi bi-person-circle"></i> <?= $lang['account'] ?>
    </button>
    <div class="collapse <?= in_array($current, ['change_password.php']) ? 'show' : '' ?>" id="accountMenu">
        <div class="submenu">
            <a href="change_password.php" class="<?= $current == 'change_password.php' ? 'active-link' : '' ?>"><i class="bi bi-key-fill"></i> <?= $lang['change_password'] ?></a>
            <a href="auth/logout.php" class="text-danger"><i class="bi bi-box-arrow-right"></i> <?= $lang['logout'] ?></a>
        </div>
    </div>
</div>




<!-- القائمة الجانبية للموبايل -->
<div class="offcanvas offcanvas-start text-bg-dark" tabindex="-1" id="mobileSidebar">
  <div class="offcanvas-header">
    <h5 class="offcanvas-title"><?= $lang['main'] ?></h5>
    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas" aria-label="Close"></button>
  </div>
  <div class="offcanvas-body p-0">
    <div class="p-3">
      <div class="text-center mb-3">
        <a href="?lang=<?= $lang_code === 'arabic' ? 'english' : 'arabic' ?>" class="lang-switch">
          🌐 <?= $lang_code === 'arabic' ? 'English' : 'العربية' ?>
        </a>
      </div>

      <img src="images/logo.png" alt="Logo" class="logo mb-3" style="width: 100px; display:block; margin:auto;">
      <div class="user-info text-center mb-3"><?= htmlspecialchars($user_name) ?></div>
<!-- STATISTICS -->
<button class="btn text-start text-white mb-2" onclick="location.href='main.php'">
    <i class="bi bi-bar-chart-line-fill"></i> <?= $lang['statistics'] ?? 'Statistics' ?>
</button>

      <!-- SYSTEM -->
      <button class="btn text-start text-white" data-bs-toggle="collapse" data-bs-target="#mobileSystemMenu" aria-expanded="<?= in_array($current, ['view_voucher.php', 'index.php', 'edit_terms.php']) ? 'true' : 'false' ?>">
        <i class="bi bi-gear-fill"></i> <?= $lang['system'] ?>
      </button>
      <div class="collapse <?= in_array($current, ['view_voucher.php', 'index.php', 'edit_terms.php']) ? 'show' : '' ?>" id="mobileSystemMenu">
        <div class="submenu">
          <a href="view_voucher.php" class="<?= $current == 'view_voucher.php' ? 'active-link' : '' ?>"><i class="bi bi-speedometer2"></i> <?= $lang['view_vouchers'] ?></a>
          <a href="index.php" class="<?= $current == 'index.php' ? 'active-link' : '' ?>"><i class="bi bi-plus-square"></i> <?= $lang['add_voucher'] ?></a>
          <?php if ($user_id == 1): ?>
            <a href="edit_terms.php" class="<?= $current == 'edit_terms.php' ? 'active-link' : '' ?>"><i class="bi bi-pencil-square"></i> <?= $lang['edit_terms'] ?></a>
          <?php endif; ?>
        </div>
      </div>
      
      <!-- FOLLOW UP -->
<button class="btn text-start text-white mt-2" data-bs-toggle="collapse" data-bs-target="#followupMenu" aria-expanded="<?= in_array($current, ['view_customers.php', 'add_customer.php']) ? 'true' : 'false' ?>">
    <i class="bi bi-journal-text"></i> <?= $lang['follow_up'] ?>
</button>
<div class="collapse <?= in_array($current, ['view_customers.php', 'add_customer.php']) ? 'show' : '' ?>" id="followupMenu">
    <div class="submenu">
        <a href="view_customers.php" class="<?= $current == 'view_customers.php' ? 'active-link' : '' ?>"><i class="bi bi-list-ul"></i> <?= $lang['view_customers'] ?></a>
        <a href="add_customer.php" class="<?= $current == 'add_customer.php' ? 'active-link' : '' ?>"><i class="bi bi-person-plus"></i> <?= $lang['add_customer'] ?></a>
    </div>
</div>



<!-- FLIGHT DETAILS -->
<button class="btn text-start text-white mt-2" data-bs-toggle="collapse" data-bs-target="#mobileFlightMenu" aria-expanded="<?= in_array($current, ['add_flight_details.php', 'view_flight_details.php']) ? 'true' : 'false' ?>">
    <i class="bi bi-airplane"></i> <?= $lang['flight_details'] ?>
</button>
<div class="collapse <?= in_array($current, ['add_flight_details.php', 'view_flight_details.php']) ? 'show' : '' ?>" id="mobileFlightMenu">
    <div class="submenu">
        <a href="add_flight_details.php" class="<?= $current == 'add_flight_details.php' ? 'active-link' : '' ?>">
            <i class="bi bi-plus-circle"></i> <?= $lang['add_flight_details'] ?>
        </a>
        <a href="view_flight_details.php" class="<?= $current == 'view_flight_details.php' ? 'active-link' : '' ?>">
            <i class="bi bi-list-ul"></i> <?= $lang['view_flight_details'] ?>
        </a>
    </div>
</div>


      <!-- USERS -->
      <?php if (in_array($user_id, [1, 2])): ?>
        <button class="btn text-start text-white mt-2" data-bs-toggle="collapse" data-bs-target="#mobileUserMenu" aria-expanded="<?= in_array($current, ['users.php', 'add_user.php']) ? 'true' : 'false' ?>">
          <i class="bi bi-people-fill"></i> <?= $lang['users'] ?>
        </button>
        <div class="collapse <?= in_array($current, ['users.php', 'add_user.php']) ? 'show' : '' ?>" id="mobileUserMenu">
          <div class="submenu">
            <a href="users.php" class="<?= $current == 'users.php' ? 'active-link' : '' ?>"><i class="bi bi-person-lines-fill"></i> <?= $lang['view_users'] ?></a>
            <a href="add_user.php" class="<?= $current == 'add_user.php' ? 'active-link' : '' ?>"><i class="bi bi-person-plus-fill"></i> <?= $lang['add_user'] ?></a>
          </div>
        </div>
      <?php endif; ?>

      <!-- ACCOUNT -->
      <button class="btn text-start text-white mt-2" data-bs-toggle="collapse" data-bs-target="#mobileAccountMenu" aria-expanded="<?= in_array($current, ['change_password.php']) ? 'true' : 'false' ?>">
        <i class="bi bi-person-circle"></i> <?= $lang['account'] ?>
      </button>
      <div class="collapse <?= in_array($current, ['change_password.php']) ? 'show' : '' ?>" id="mobileAccountMenu">
        <div class="submenu">
          <a href="change_password.php" class="<?= $current == 'change_password.php' ? 'active-link' : '' ?>"><i class="bi bi-key-fill"></i> <?= $lang['change_password'] ?></a>
          <a href="auth/logout.php" class="text-danger"><i class="bi bi-box-arrow-right"></i> <?= $lang['logout'] ?></a>
        </div>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
