<?php
ob_start();
require_once 'config/config.php';
require_once __DIR__ . '/vendor/autoload.php';

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Invalid voucher ID.");
}

$id = intval($_GET['id']);

$stmt = $conn->prepare("SELECT * FROM vouchers WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    die("Voucher not found.");
}

$data = $result->fetch_assoc();

// جلب اسم المستخدم من جدول users
$prepared_by = 'User';
$user_email = '';
$user_website = '';
$user_landline = '';
$user_mobile = '';

if (!empty($data['entered_by'])) {
    $user_id = (int) $data['entered_by'];
    $stmt = $conn->prepare("SELECT name, email, website, landline, mobile FROM users WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($user = $result->fetch_assoc()) {
        $prepared_by = htmlspecialchars($user['name']);
        $user_email = htmlspecialchars($user['email']);
        $user_website = htmlspecialchars($user['website']);
        $user_landline = htmlspecialchars($user['landline']);
        $user_mobile = htmlspecialchars($user['mobile']);
    }
}

$mpdf = new \Mpdf\Mpdf([
    'mode' => 'utf-8',
    'format' => 'A4',
    'margin_top' => 0,
    'margin_bottom' => 0,
    'margin_left' => 0,
    'margin_right' => 0,
    'default_font' => 'dejavusans'
]);

$download_url = 'https://safana-sys.com/new/generate_pdf.php?id=' . $id;
$qr_code_html = '<barcode code="' . $download_url . '" type="QR" size="1" error="M" disableborder="true" />';

$html = '
<div style="width:100%;position:relative;font-family:dejavusans;font-size:12pt;margin:0;padding:0;">
    <!-- الهيدر -->
    <img src="images/header.png" style="width:100%;display:block;" />

    <div style="padding:0 20px 40px 20px;position:relative;z-index:10;">

        <!-- العنوان الرئيسي -->
        <div style="text-align:center;font-weight:bold;font-size:14pt;margin:5px 0 5px 0;">
            Bebek Travel & Tourism Hotels Operation and Management
        </div>

        <!-- سطر QR + البيانات -->
        <table style="width:100%;border-collapse:collapse;margin:5px 0;">
            <tr>
                <td style="padding:6px 10px;border:1px solid #aaa;font-size:10pt;width:25%;">
                    <strong>Date:</strong><br>' . htmlspecialchars($data['voucher_date'] ?? '') . '
                </td>
                <td style="padding:6px 10px;border:1px solid #aaa;font-size:10pt;width:25%;">
                    <strong>Status:</strong><br>' . htmlspecialchars($data['status'] ?? '') . '
                </td>
                <td style="padding:6px 10px;border:1px solid #aaa;font-size:10pt;width:25%;">
                    <strong>Booking Ref:</strong><br>' . htmlspecialchars($data['booking_number'] ?? '') . '
                </td>
                <td style="padding:6px;border:1px solid #aaa;text-align:center;width:25%;vertical-align:middle;">
                    <div style="display:inline-block;width:60px;height:60px;">
                        ' . str_replace('size="1"', 'size="0.6"', $qr_code_html) . '
                    </div>
                </td>
            </tr>
        </table>
<!-- قسم أسماء الضيوف -->
<div style="font-weight:bold;font-size:12pt;margin:25px 0 10px;color:#333;">Guest Information</div>
<table style="width:100%;border-collapse:collapse;margin:5px 0;">
    <thead>
        <tr>
            <th style="background:#f0f0f0;font-weight:bold;border:1px solid #999;
                       padding:8px;font-size:10pt;text-align:center;">
                Guest Name(s)
            </th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td style="border:1px solid #999;padding:8px;font-size:10pt;text-align:center;">
                ';
                $guestsRaw = $data['customer_name'] ?? "";
                if (!empty($guestsRaw)) {
                    $guestList = array_map("trim", explode(",", $guestsRaw));
                    $html .= implode(" | ", array_map("htmlspecialchars", $guestList));
                } else {
                    $html .= "-";
                }
$html .= '
            </td>
        </tr>
    </tbody>
</table>




        <div style="font-weight:bold;font-size:12pt;margin:25px 0 10px;color:#333;">Hotel Details</div>
        <table style="width:100%;border-collapse:collapse;margin-bottom:15px;">
            <thead>
                <tr>
                    <th style="background:#f0f0f0;font-weight:bold;border:1px solid #999;padding:8px;font-size:10pt;">Hotel</th>
                    <th style="background:#f0f0f0;font-weight:bold;border:1px solid #999;padding:8px;font-size:10pt;">City</th>
                    <th style="background:#f0f0f0;font-weight:bold;border:1px solid #999;padding:8px;font-size:10pt;">Confirmation Number</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td style="border:1px solid #999;padding:8px;font-size:10pt;text-align:center;">' . htmlspecialchars($data['hotel_name'] ?? '') . '</td>
                    <td style="border:1px solid #999;padding:8px;font-size:10pt;text-align:center;">' . htmlspecialchars($data['city'] ?? '') . '</td>
                    <td style="border:1px solid #999;padding:8px;font-size:10pt;text-align:center;">' . htmlspecialchars($data['hotel_confirmation_number'] ?? '') . '</td>
                </tr>
            </tbody>
        </table>

        <div style="font-weight:bold;font-size:12pt;margin:25px 0 10px;color:#333;">Reservation Details</div>
        <table style="width:100%;border-collapse:collapse;">
            <thead>
                <tr>
                    <th style="background:#f0f0f0;font-weight:bold;border:1px solid #999;padding:8px;font-size:10pt;">Room Type</th>
                    <th style="background:#f0f0f0;font-weight:bold;border:1px solid #999;padding:8px;font-size:10pt;">View</th>
                    <th style="background:#f0f0f0;font-weight:bold;border:1px solid #999;padding:8px;font-size:10pt;">Level</th>
                    <th style="background:#f0f0f0;font-weight:bold;border:1px solid #999;padding:8px;font-size:10pt;">Meal</th>
                    <th style="background:#f0f0f0;font-weight:bold;border:1px solid #999;padding:8px;font-size:10pt;">Rooms</th>
                    <th style="background:#f0f0f0;font-weight:bold;border:1px solid #999;padding:8px;font-size:10pt;">Guests</th>
                    <th style="background:#f0f0f0;font-weight:bold;border:1px solid #999;padding:8px;font-size:10pt;">Check In</th>
                    <th style="background:#f0f0f0;font-weight:bold;border:1px solid #999;padding:8px;font-size:10pt;">Nts</th>
                    <th style="background:#f0f0f0;font-weight:bold;border:1px solid #999;padding:8px;font-size:10pt;">Check Out</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td style="border:1px solid #999;padding:8px;font-size:10pt;text-align:center;">' . htmlspecialchars($data['room_type'] ?? '') . '</td>
                    <td style="border:1px solid #999;padding:8px;font-size:10pt;text-align:center;">' . htmlspecialchars($data['view'] ?? '') . '</td>
                    <td style="border:1px solid #999;padding:8px;font-size:10pt;text-align:center;">' . htmlspecialchars($data['room_level'] ?? '') . '</td>
                    <td style="border:1px solid #999;padding:8px;font-size:10pt;text-align:center;">' . htmlspecialchars($data['meal_plan'] ?? '') . '</td>
                    <td style="border:1px solid #999;padding:8px;font-size:10pt;text-align:center;">' . htmlspecialchars($data['rooms_count'] ?? '') . '</td>
                    <td style="border:1px solid #999;padding:8px;font-size:10pt;text-align:center;">' . htmlspecialchars($data['guests_per_room'] ?? '') . '</td>
                    <td style="border:1px solid #999;padding:8px;font-size:10pt;text-align:center;">' . htmlspecialchars($data['check_in_date'] ?? '') . '</td>
                    <td style="border:1px solid #999;padding:8px;font-size:10pt;text-align:center;">' . htmlspecialchars($data['nights'] ?? '') . '</td>
                    <td style="border:1px solid #999;padding:8px;font-size:10pt;text-align:center;">' . htmlspecialchars($data['check_out_date'] ?? '') . '</td>
                </tr>
            </tbody>
        </table>


<!-- قسم Remarks و Company Logo -->
<div style="font-weight:bold;font-size:12pt;margin:25px 0 10px;color:#333;">Additional Information</div>
<table style="width:100%;border-collapse:collapse;">
    <thead>
        <tr>
            <th style="background:#f0f0f0;font-weight:bold;border:1px solid #999;padding:8px;font-size:10pt;width:70%;">Remarks</th>
            <th style="background:#f0f0f0;font-weight:bold;border:1px solid #999;padding:8px;font-size:10pt;width:30%;">Company Logo</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <!-- Remarks -->
            <td style="border:1px solid #999;padding:8px;font-size:10pt;vertical-align:top;">
                ' . (!empty($data['remarks']) ? nl2br(htmlspecialchars($data['remarks'])) : '-') . '
            </td>

            <!-- Company Logo -->
            <td style="border:1px solid #999;padding:8px;font-size:10pt;text-align:center;vertical-align:middle;">
                ' . (!empty($data['company_logo']) 
                    ? '<img src="' . htmlspecialchars($data['company_logo']) . '" style="max-width:120px;max-height:80px;" />' 
                    : '-') . '
            </td>
        </tr>
    </tbody>
</table>


        <div style="font-weight:bold;font-size:12pt;margin:25px 0 10px;color:#333;">Terms & Conditions</div>
        <div style="margin-top:10px;padding:10px;background:#f9f9f9;border:1px dashed #aaa;white-space:pre-wrap;font-size:10pt;">
            ' . nl2br(htmlspecialchars($data['terms'] ?? '')) . '
        </div>

        <div style="font-size:10pt;border-top:1px solid #000;width:260px;padding-top:5px;margin-top:20px;text-align:left;">
            Prepared By: ' . $prepared_by . '
        </div>
    </div>
</div>
';

$mpdf->SetHTMLFooter('
 <div style="
     width: 100%;
     background-color: #e11f28;
     color: #ffffff;
     text-transform: uppercase;
     text-align: center;
     font-size: 10pt;
     font-weight: bold;
     padding: 6px 0;
 ">
     ' . $user_website . ' | ' . $user_email . ' | ' . $user_landline . ' | ' . $user_mobile . '
 </div>');

$mpdf->WriteHTML($html);
ob_end_clean();
$mpdf->Output('voucher_' . preg_replace('/[^A-Za-z0-9_\-]/', '', $data['booking_number']) . '.pdf', 'I');
?>
