<?php
require_once 'config/config.php';
require_once 'vendor/autoload.php'; // تأكد أن مكتبة PhpSpreadsheet مثبتة

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;

session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: auth/login.php");
    exit;
}

$query = $conn->query("SELECT * FROM transport_details ORDER BY id DESC");
if ($query->num_rows === 0) {
    die("لا توجد بيانات لتصديرها.");
}

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$sheet->setTitle('Transport Details');

// إعداد الرأس
$sheet->setCellValue('A1', '#');
$sheet->setCellValue('B1', 'الأسماء');
$sheet->setCellValue('C1', 'رقم الجواز');
$sheet->setCellValue('D1', 'البيانات');
$sheet->setCellValue('E1', 'السكن');
$sheet->setCellValue('F1', 'تاريخ الوصول');
$sheet->setCellValue('G1', 'تاريخ المغادرة');
$sheet->setCellValue('H1', 'ملاحظات');

// تنسيق العناوين
$sheet->getStyle('A1:H1')->getFont()->setBold(true)->setSize(12);
$sheet->getStyle('A1:H1')->getFill()->setFillType(Fill::FILL_SOLID)
      ->getStartColor()->setARGB('FFD9C9A9');
$sheet->getStyle('A1:H1')->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);

// تعبئة البيانات
$row = 2;
$counter = 1;

while ($data = $query->fetch_assoc()) {
    $sheet->setCellValue("A{$row}", $counter);
    $sheet->setCellValue("B{$row}", $data['customer_name']);
    $sheet->setCellValue("C{$row}", ""); // يمكن إضافة رقم الجواز لاحقًا
    $sheet->setCellValue("D{$row}", "فندق مكة\nفندق المدينة\nطيران\nسيارة\nملاحظات إضافية\nرقم هاتف المعتمر\nعدد الأشخاص");

    // السكن والمواعيد
    $sheet->setCellValue("E{$row}", $data['car_type']);
    $sheet->setCellValue("F{$row}", $data['arrival_date']);
    $sheet->setCellValue("G{$row}", $data['departure_date']);

    // الملاحظات النهائية
    $sheet->setCellValue("H{$row}", 
        "{$data['arrival_notes']}\n{$data['departure_notes']}\n{$data['flight_details']}\n{$data['extra_notes']}\n{$data['pilgrim_phone']}\nعدد الأشخاص: {$data['persons_count']}"
    );

    $sheet->getStyle("A{$row}:H{$row}")->getAlignment()->setWrapText(true);
    $sheet->getStyle("A{$row}:H{$row}")->getBorders()->getAllBorders()
        ->setBorderStyle(Border::BORDER_THIN);

    $row++;
    $counter++;
}

// ضبط العرض التلقائي للأعمدة
foreach (range('A', 'H') as $col) {
    $sheet->getColumnDimension($col)->setAutoSize(true);
}

// إخراج الملف للتحميل
$filename = 'transport_details_' . date('Ymd_His') . '.xlsx';
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header("Content-Disposition: attachment; filename=\"$filename\"");
header('Cache-Control: max-age=0');

$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit;
?>
