<?php
require_once 'config/config.php';

session_start();
$user_id = $_SESSION['user_id'] ?? null;

// السماح فقط لليوزرات المحددين
if (!in_array($user_id, [1, 2])) {
    header("Location: dashboard.php");
    exit;
}

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: dashboard.php");
    exit;
}

$id = intval($_GET['id']);

// ✅ جلب الشعار (لو موجود) قبل الحذف
$stmt = $conn->prepare("SELECT company_logo FROM vouchers WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$voucher = $result->fetch_assoc();
$stmt->close();

if ($voucher && !empty($voucher['company_logo'])) {
    $logoPath = $voucher['company_logo'];
    if (file_exists($logoPath)) {
        unlink($logoPath); // حذف الملف من السيرفر
    }
}

// ✅ حذف الفاوتشر من جدول vouchers
$stmt = $conn->prepare("DELETE FROM vouchers WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$stmt->close();

header("Location: view_voucher.php");
exit;
