<?php
ini_set('max_execution_time', 600);
ini_set('memory_limit', '2048M');
header('Content-Type: text/html; charset=utf-8');

$data_dir = __DIR__;
$airlines_file = "$data_dir/airlines.json";
$progress_file = "$data_dir/progress.json";

/**
 * ترجمة باستخدام Google Translate (واجهة مجانية)
 */
function translateText($text, $target = 'ar', $source = 'en') {
    $url = "https://translate.googleapis.com/translate_a/single?client=gtx&sl={$source}&tl={$target}&dt=t&q=" . urlencode($text);
    $response = @file_get_contents($url);
    if ($response === false) return $text;
    $json = json_decode($response, true);
    return $json[0][0][0] ?? $text;
}

/**
 * تحميل التقدم
 */
function loadProgress($file) {
    return file_exists($file) ? json_decode(file_get_contents($file), true) : ['offset' => 0];
}

/**
 * حفظ التقدم
 */
function saveProgress($file, $offset) {
    file_put_contents($file, json_encode(['offset' => $offset]));
}

/**
 * ترجمة دفعة محددة من JSON
 */
function translateBatch($file, $fields, $progress_file, $batch_size = 300) {
    if (!file_exists($file)) die("❌ الملف غير موجود: $file");

    $data = json_decode(file_get_contents($file), true);
    $progress = loadProgress($progress_file);
    $offset = $progress['offset'];
    $total = count($data);

    echo "📦 معالجة من $offset إلى " . min($offset + $batch_size, $total) . " من أصل $total سجل...<br>";

    $count = 0;
    for ($i = $offset; $i < min($offset + $batch_size, $total); $i++) {
        foreach ($fields as $src => $dest) {
            if (!empty($data[$i][$src])) {
                $data[$i][$dest] = translateText($data[$i][$src]);
                usleep(200000); // تأخير بسيط لتجنب الحظر
            }
        }
        $count++;
    }

    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    saveProgress($progress_file, $offset + $count);

    if ($offset + $count >= $total) {
        unlink($progress_file);
        echo "✅ تمت ترجمة الملف بالكامل.<br>";
    } else {
        echo "⏩ تم إنجاز دفعة عددها $count. أعد تحميل الصفحة لتكملة الباقي.<br>";
    }
}

/* ترجم دفعات من شركات الطيران */
translateBatch($airlines_file, [
    'airline_name' => 'airline_name_ar',
    'country' => 'country_ar'
], $progress_file);
?>
