<?php
require_once 'config/config.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    http_response_code(403);
    exit("Not authorized");
}

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    http_response_code(400);
    exit("Invalid ID");
}

$id = intval($_GET['id']);

// 🔹 جلب البيانات من الجدول الأصلي
$stmt = $conn->prepare("SELECT * FROM transit_visas WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    http_response_code(404);
    exit("Record not found");
}

$data = $result->fetch_assoc();

// 🔹 إدخال البيانات في جدول المكتملة
$stmt = $conn->prepare("
    INSERT INTO completed_transit_visas 
    (passenger_name, issued, issue_date, travel_date, booking_nas_go, booking_nas_return, status, created_at)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?)
");
$stmt->bind_param(
    "sissssss",
    $data['passenger_name'],
    $data['issued'],
    $data['issue_date'],
    $data['travel_date'],
    $data['booking_nas_go'],
    $data['booking_nas_return'],
    $data['status'],
    $data['created_at']
);
$stmt->execute();

// 🔹 حذف السطر من الجدول الأصلي
$stmt = $conn->prepare("DELETE FROM transit_visas WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();

echo json_encode(["success" => true]);
