<?php
require_once '../config/config.php';

$success = '';
$error = '';
$name = '';
$email_prefix = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name         = trim($_POST['name']);
    $email_prefix = trim($_POST['email']);
    $email        = $email_prefix . '@marshaltravel.com';
    $password     = $_POST['password'];

    if ($name && $email_prefix && $password) {
        $stmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            $error = $lang['email_exists'];
        } else {
            $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
            $insert = $conn->prepare("INSERT INTO users (name, email, password) VALUES (?, ?, ?)");
            $insert->bind_param("sss", $name, $email, $hashedPassword);
            if ($insert->execute()) {
                $success = $lang['registration_success'];
                $name = '';
                $email_prefix = '';
            } else {
                $error = $lang['registration_failed'];
            }
        }
    } else {
        $error = $lang['fill_all_fields'];
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?= $lang['register'] ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .logo {
            display: block;
            margin: 30px auto 10px auto;
            width: 150px;
        }
    </style>
</head>
<body>

<img src="../images/logo.png" alt="<?= $lang['register'] ?>" class="logo">

<div class="container mt-3" style="max-width: 500px;">
    <h2 class="text-center mb-4"><?= $lang['register'] ?></h2>

    <?php if ($success): ?>
        <div class="alert alert-success"><?= $success ?></div>
    <?php elseif ($error): ?>
        <div class="alert alert-danger"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST">
        <div class="mb-3">
            <label class="form-label"><?= $lang['name'] ?></label>
            <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($name) ?>" required>
        </div>

        <div class="mb-3">
            <label class="form-label"><?= $lang['email'] ?></label>
            <div class="input-group">
                <input type="text" name="email" class="form-control" value="<?= htmlspecialchars($email_prefix) ?>" required>
                <span class="input-group-text">@marshaltravel.com</span>
            </div>
        </div>

        <div class="mb-3">
            <label class="form-label"><?= $lang['password'] ?></label>
            <input type="password" name="password" class="form-control" required>
        </div>

        <button type="submit" class="btn btn-primary w-100"><?= $lang['register_button'] ?></button>
    </form>
</div>

<?php include '../includes/footer.php'; ?>
