<?php
require_once 'config/config.php';
session_start();

// التحقق من تسجيل الدخول
if (!isset($_SESSION['user_id'])) {
    header("Location: auth/login.php");
    exit;
}

$result_text = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $airline          = $_POST['airline'] ?? null;
    $departure_route  = $_POST['departure_route'] ?? null;
    $return_route     = $_POST['return_route'] ?? null;

    // التواريخ
    $departure_date = ($_POST['departure_day'] ?? "01") . "/" . ($_POST['departure_month'] ?? "01") . "/" . ($_POST['departure_year'] ?? "2025");
    $return_date    = ($_POST['return_day'] ?? "01") . "/" . ($_POST['return_month'] ?? "01") . "/" . ($_POST['return_year'] ?? "2025");

    $departure_time = $_POST['departure_time'] ?? null;
    $return_time    = $_POST['return_time'] ?? null;

    // الفنادق
    $hotel_makkah       = $_POST['hotel_makkah'] ?? null;
    $hotel_makkah_stars = $_POST['hotel_makkah_stars'] ?? null;
    $hotel_makkah_distance = $_POST['hotel_makkah_distance'] ?? null;
    $hotel_makkah_meal  = $_POST['hotel_makkah_meal'] ?? null;
$hotel_makkah_nights = $_POST['hotel_makkah_nights'] ?? null;

    $hotel_madina       = $_POST['hotel_madina'] ?? null;
    $hotel_madina_stars = $_POST['hotel_madina_stars'] ?? null;
    $hotel_madina_distance = $_POST['hotel_madina_distance'] ?? null;
    $hotel_madina_meal  = $_POST['hotel_madina_meal'] ?? null;
$hotel_madina_nights = $_POST['hotel_madina_nights'] ?? null;
    // الأقسام الجديدة
    $visa_type   = $_POST['visa_type'] ?? null;
    $transport   = $_POST['transport'] ?? null;
    $includes    = isset($_POST['includes']) ? $_POST['includes'] : [];
    $flight_ticket = $_POST['flight_ticket'] ?? null;
    $addons      = isset($_POST['addons']) ? $_POST['addons'] : [];

    // الأسعار
    $price_single = $_POST['price_single'] ?? null;
    $price_double = $_POST['price_double'] ?? null;
    $price_triple = $_POST['price_triple'] ?? null;
    $price_quad   = $_POST['price_quad'] ?? null;

    // دالة تنسيق الوقت
    function formatTimeArabic($time) {
        $hour = (int)date("H", strtotime($time));
        if ($hour >= 5 && $hour < 12) return "صباحا";
        if ($hour >= 12 && $hour < 15) return "ظهرا";
        if ($hour >= 15 && $hour < 18) return "عصرا";
        if ($hour >= 18 && $hour < 24) return "مساءً";
        return "فجرا";
    }

    $dep_period = $departure_time ? formatTimeArabic($departure_time) : "";
    $ret_period = $return_time ? formatTimeArabic($return_time) : "";

    // بناء النص النهائي
    $result_text  = "برنامج عمرة :\n";
    $result_text .= "$airline ($departure_route - $return_route)\n";
    $result_text .= "تاريخ وموعد الذهاب : $departure_date // الاقلاع الساعة $departure_time $dep_period\n";
    $result_text .= "تاريخ وموعد العودة : $return_date // الاقلاع الساعة $return_time $ret_period\n\n";

    // الفنادق
if ($hotel_makkah) {
    $result_text .= "فندق مكة : $hotel_makkah ( $hotel_makkah_stars – $hotel_makkah_distance متر عن الحرم ) – إقامة $hotel_makkah_nights ليالي – $hotel_makkah_meal\n";
}
if ($hotel_madina) {
    $result_text .= "فندق المدينة : $hotel_madina ( $hotel_madina_stars – $hotel_madina_distance متر عن الحرم ) – إقامة $hotel_madina_nights ليالي – $hotel_madina_meal\n";
}
    $result_text .= "\n";

    // الأسعار تشمل
    $result_text .= "الاسعار تشمل :\n";
    if ($visa_type) {
        $result_text .= "- التأشيرات ($visa_type)\n";
    }
    if ($transport) {
        $result_text .= "- النقل ($transport)\n";
    }
    if (!empty($includes)) {
        foreach ($includes as $inc) {
            $result_text .= "- $inc\n";
        }
    }
    if ($flight_ticket) {
        $result_text .= "- تذاكر الطيران: $flight_ticket\n";
    }
if (!empty($addons)) {
    foreach ($addons as $add) {
        if ($add == "20+7_40jd") 
            $result_text .= "- في حال تم طلب وزن 20 كيلو + 7 كيلو هاند باج يتم إضافة مبلغ 40 دينار لكل شخص مع وزن\n";

        if ($add == "23+7_50jd") 
            $result_text .= "- في حال تم طلب وزن 23 كيلو + 7 كيلو هاند باج يتم إضافة مبلغ 50 دينار لكل شخص مع وزن\n";

        if ($add == "visa_umrah_75jd") 
            $result_text .= "- إضافة 75 دينار للشخص عند طلب تأشيرة عمرة\n";

        if ($add == "breakfast_30jd") 
            $result_text .= "- إضافة 30 دينار للشخص عند طلب شامل الإفطار\n";

        if ($add == "bag_size_40_20_30") 
            $result_text .= "- قياسات الشنط المسموحة (40 × 20 × 30 سم)\n";
    }
}
$result_text .= "\n";

    // الأسعار
    if ($price_single || $price_double || $price_triple || $price_quad) {
        if ($price_single) $result_text .= "السعر للشخص في الغرفة المنفردة : $price_single دينار\n";
        if ($price_double) $result_text .= "السعر للشخص في الغرفة الثنائية : $price_double دينار\n";
        if ($price_triple) $result_text .= "السعر للشخص في الغرفة الثلاثية : $price_triple دينار\n";
        if ($price_quad)   $result_text .= "السعر للشخص في الغرفة الرباعية : $price_quad دينار\n";
    }
    
    
    // حفظ النص في قاعدة البيانات
if (!empty($result_text)) {
    $sql = "INSERT INTO quotes (result_text) VALUES (?)";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $result_text);
$stmt->execute();

}

}
?>

<?php include 'header.php'; ?>
<div class="main-content p-4" style="flex:1;">
    <h2 class="mb-4">إضافة عرض سعر</h2>

    <form method="POST" class="mb-4">

        <!-- الطيران -->
        <div class="row mb-3">
            <div class="col">
                <label class="form-label">نوع الطيران</label>
              <select name="airline" class="form-control" required>
    <option value="الطيران السعودي" <?= (isset($_POST['airline']) && $_POST['airline'] == "الطيران السعودي") ? 'selected' : '' ?>>الطيران السعودي</option>
    <option value="الملكية الأردنية" <?= (isset($_POST['airline']) && $_POST['airline'] == "الملكية الأردنية") ? 'selected' : '' ?>>الملكية الأردنية</option>
    <option value="طيران ناس" <?= (isset($_POST['airline']) && $_POST['airline'] == "طيران ناس") ? 'selected' : '' ?>>طيران ناس</option>
    <option value="طيران أديل" <?= (isset($_POST['airline']) && $_POST['airline'] == "طيران أديل") ? 'selected' : '' ?>>طيران أديل</option>
</select>

            </div>
            <div class="col">
                <label class="form-label">مدينة الذهاب</label>
                <select name="departure_route" class="form-control" required>
                    <option value="من عمان إلى جدة">من عمان إلى جدة</option>
                    <option value="من عمان إلى المدينة">من عمان إلى المدينة</option>
                </select>
            </div>
            <div class="col">
                <label class="form-label">مدينة العودة</label>
                <select name="return_route" class="form-control" required>
                    <option value="من جدة إلى عمان">من جدة إلى عمان</option>
                    <option value="من المدينة إلى عمان">من المدينة إلى عمان</option>
                </select>
            </div>
        </div>

<div class="row mb-3">
    <!-- يوم الذهاب -->
<div class="col-1">
    <label class="form-label">يوم الذهاب</label>
    <input type="number" name="departure_day" class="form-control" min="1" max="31" placeholder="01" required>
</div>
    <!-- شهر الذهاب -->
    <div class="col-1">
        <label class="form-label">شهر الذهاب</label>
        <select name="departure_month" class="form-control" required>
            <?php $currentMonth = date("n");
            for($m=1; $m<=12; $m++):
                $val = str_pad($m,2,"0",STR_PAD_LEFT); ?>
                <option value="<?= $val ?>" <?= $m==$currentMonth ? "selected" : "" ?>><?= $val ?></option>
            <?php endfor; ?>
        </select>
    </div>
    <!-- سنة الذهاب -->
    <div class="col-1">
        <label class="form-label">سنة الذهاب</label>
        <select name="departure_year" class="form-control" required>
            <option value="2025" selected>2025</option>
            <option value="2026">2026</option>
        </select>
    </div>
    <!-- وقت الذهاب -->
    <div class="col-3">
        <label class="form-label">وقت الذهاب</label>
        <input type="time" id="departure_time" name="departure_time" class="form-control" required>
        <div class="mt-1">
            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="setTime('departure_time','13:30')">13:30</button>
            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="setTime('departure_time','10:30')">10:30</button>
            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="setTime('departure_time','15:10')">15:10</button>
            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="setTime('departure_time','17:10')">17:10</button>

        </div>
    </div>

    <!-- يوم العودة -->
<div class="col-1">
    <label class="form-label">يوم العودة</label>
    <input type="number" name="return_day" class="form-control" min="1" max="31" placeholder="01" required>
</div>
    <!-- شهر العودة -->
    <div class="col-1">
        <label class="form-label">شهر العودة</label>
        <select name="return_month" class="form-control" required>
            <?php for($m=1; $m<=12; $m++):
                $val = str_pad($m,2,"0",STR_PAD_LEFT); ?>
                <option value="<?= $val ?>" <?= $m==$currentMonth ? "selected" : "" ?>><?= $val ?></option>
            <?php endfor; ?>
        </select>
    </div>
    <!-- سنة العودة -->
    <div class="col-1">
        <label class="form-label">سنة العودة</label>
        <select name="return_year" class="form-control" required>
            <option value="2025" selected>2025</option>
            <option value="2026">2026</option>
        </select>
    </div>
    <!-- وقت العودة -->
    <div class="col-3">
        <label class="form-label">وقت العودة</label>
        <input type="time" id="return_time" name="return_time" class="form-control" required>
        <div class="mt-1">
            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="setTime('return_time','17:30')">17:30</button>
            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="setTime('return_time','12:25')">12:25</button>
            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="setTime('return_time','14:15')">14:15</button>

            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="setTime('return_time','19:40')">19:40</button>
            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="setTime('return_time','20:55')">20:55</button>
        </div>
    </div>
</div>

<script>
function setTime(field, value){
    document.getElementById(field).value = value;
}
</script>

<!-- فندق مكة -->
<h4 class="mt-4">فندق مكة</h4>
<div class="row mb-3">
    <div class="col">
        <label class="form-label">اسم الفندق</label>
        <input type="text" name="hotel_makkah" class="form-control" required>
    </div>
    <div class="col">
        <label class="form-label">عدد النجوم</label>
        <select name="hotel_makkah_stars" class="form-control">
            <option value="اقتصادي">اقتصادي</option>
            <option value="3 نجوم">3 نجوم</option>
            <option value="4 نجوم">4 نجوم</option>
            <option value="5 نجوم">5 نجوم</option>
        </select>
    </div>
    <div class="col">
        <label class="form-label">المسافة عن الحرم (م)</label>
        <input type="text" name="hotel_makkah_distance" class="form-control">
    </div>
    <div class="col">
        <label class="form-label">الوجبات</label>
        <select name="hotel_makkah_meal" class="form-control">
            <option value="بدون وجبات">بدون وجبات</option>
            <option value="شامل الإفطار">شامل الإفطار</option>
            <option value="شامل الإفطار والعشاء">شامل الإفطار والعشاء</option>
        </select>
    </div>
    <div class="col">
        <label class="form-label">عدد الليالي</label>
        <input type="text" name="hotel_makkah_nights" class="form-control">
    </div>
</div>

<!-- فندق المدينة -->
<h4 class="mt-4">فندق المدينة</h4>
<div class="row mb-3">
    <div class="col">
        <label class="form-label">اسم الفندق</label>
        <input type="text" name="hotel_madina" class="form-control">
    </div>
    <div class="col">
        <label class="form-label">عدد النجوم</label>
        <select name="hotel_madina_stars" class="form-control">
            <option value="اقتصادي">اقتصادي</option>
            <option value="3 نجوم">3 نجوم</option>
            <option value="4 نجوم">4 نجوم</option>
            <option value="5 نجوم">5 نجوم</option>
        </select>
    </div>
    <div class="col">
        <label class="form-label">المسافة عن الحرم (م)</label>
        <input type="number" name="hotel_madina_distance" class="form-control">
    </div>
    <div class="col">
        <label class="form-label">الوجبات</label>
        <select name="hotel_madina_meal" class="form-control">
            <option value="بدون وجبات">بدون وجبات</option>
            <option value="شامل الإفطار">شامل الإفطار</option>
            <option value="شامل الإفطار والعشاء">شامل الإفطار والعشاء</option>
        </select>
    </div>
    <div class="col">
        <label class="form-label">عدد الليالي</label>
        <input type="number" name="hotel_madina_nights" class="form-control">
    </div>
</div>


<!-- الأسعار تشمل -->
<h4 class="mt-4">الأسعار تشمل</h4>

<!-- القسم الأول: التأشيرات -->
<div class="mb-3">
    <label class="form-label fw-bold">التأشيرات</label><br>
    <div class="form-check">
        <input type="radio" name="visa_type" value="عمرة" class="form-check-input" required>
        <label class="form-check-label">عمرة</label>
    </div>
    <div class="form-check">
        <input type="radio" name="visa_type" value="مرور" class="form-check-input">
        <label class="form-check-label">مرور</label>
    </div>
    <div class="form-check">
        <input type="radio" name="visa_type" value="سياحية" class="form-check-input">
        <label class="form-check-label">سياحية</label>
    </div>
</div>

<!-- القسم الثاني: النقل -->
<div class="mb-3">
    <label class="form-label fw-bold">النقل</label><br>
    <div class="form-check">
        <input type="radio" name="transport" value="سيارة خاصة كامل الرحلة" class="form-check-input" required>
        <label class="form-check-label">سيارة خاصة كامل الرحلة</label>
    </div>
    <div class="form-check">
        <input type="radio" name="transport" value="سيارة خاصة + قطار بين مكة والمدينة" class="form-check-input">
        <label class="form-check-label">سيارة خاصة + قطار بين مكة والمدينة</label>
    </div>
    <div class="form-check">
        <input type="radio" name="transport" value="قطار" class="form-check-input">
        <label class="form-check-label">قطار</label>
    </div>
    <div class="form-check">
        <input type="radio" name="transport" value="قروب" class="form-check-input">
        <label class="form-check-label">قروب</label>
    </div>
</div>

<!-- القسم الثالث: جميع الضرائب -->
<div class="mb-3">
    <div class="form-check">
        <input type="checkbox" name="includes[]" value="جميع الضرائب" class="form-check-input" checked>
        <label class="form-check-label">جميع الضرائب</label>
    </div>
</div>

<!-- القسم الرابع: الإقامة بالفنادق -->
<div class="mb-3">
    <div class="form-check">
        <input type="checkbox" name="includes[]" value="الإقامة بالفنادق" class="form-check-input" checked>
        <label class="form-check-label">الإقامة بالفنادق</label>
    </div>
</div>

<!-- القسم الخامس: تذاكر الطيران -->
<div class="mb-3">
    <label class="form-label fw-bold">تذاكر الطيران</label><br>
    <div class="form-check">
        <input type="radio" name="flight_ticket" value="بدون وزن 7 كيلو فقط" class="form-check-input" required>
        <label class="form-check-label">بدون وزن 7 كيلو هاند باج فقط</label>
    </div>
    <div class="form-check">
        <input type="radio" name="flight_ticket" value="مع وزن 23+7" class="form-check-input">
        <label class="form-check-label">مع وزن 23 كيلو + 7 كيلو هاند باج</label>
    </div>
</div>

<!-- القسم السادس: الإضافات -->
<div class="mb-3">
    <label class="form-label fw-bold">الإضافات</label><br>
    <div class="form-check">
        <input type="checkbox" name="addons[]" value="20+7_40jd" class="form-check-input">
        <label class="form-check-label">20 كيلو + 7 كيلو هاند باج (+40 دينار للشخص)</label>
    </div>
    <div class="form-check">
        <input type="checkbox" name="addons[]" value="23+7_50jd" class="form-check-input">
        <label class="form-check-label">23 كيلو + 7 كيلو هاند باج (+50 دينار للشخص)</label>
    </div>
    <div class="form-check">
        <input type="checkbox" name="addons[]" value="visa_umrah_75jd" class="form-check-input">
        <label class="form-check-label">إضافة 75 دينار للشخص عند طلب تأشيرة عمرة</label>
    </div>
    <div class="form-check">
        <input type="checkbox" name="addons[]" value="breakfast_30jd" class="form-check-input">
        <label class="form-check-label">إضافة 30 دينار للشخص الواحد عند طلب شامل الإفطار</label>
    </div>
    
    
    <div class="form-check">
    <input type="checkbox" name="addons[]" value="bag_size_40_20_30" class="form-check-input">
    <label class="form-check-label">قياسات الشنط المسموحة (40 × 20 × 30 سم)</label>
</div>

</div>

<!-- الأسعار -->
<h4 class="mt-4">الأسعار</h4>
<div class="row mb-3">
    <div class="col">
        <label class="form-label">منفرد</label>
        <input type="number" name="price_single" class="form-control">
    </div>
    <div class="col">
        <label class="form-label">ثنائي</label>
        <input type="number" name="price_double" class="form-control">
    </div>
    <div class="col">
        <label class="form-label">ثلاثي</label>
        <input type="number" name="price_triple" class="form-control">
    </div>
    <div class="col">
        <label class="form-label">رباعي</label>
        <input type="number" name="price_quad" class="form-control">
    </div>
</div>

        <button type="submit" class="btn btn-success">عرض النص</button>
    </form>
  <!-- النموذج (نفس اللي عندك بدون تغيير) -->

    <?php if ($result_text): ?>
        <h4>النص الناتج:</h4>
        <div class="card">
            <div class="card-body">
                <textarea id="resultBox" rows="20" class="form-control"><?= htmlspecialchars($result_text) ?></textarea>
                <button class="btn btn-primary mt-2" onclick="copyText()">📋 نسخ النص</button>
            </div>
        </div>
    <?php endif; ?>
</div>

<script>
function copyText() {
    var copyText = document.getElementById("resultBox");
    copyText.select();
    document.execCommand("copy");
    alert("تم نسخ النص ✅");
}
</script>

<?php include 'includes/footer.php'; ?>
