<?php
require_once 'config/config.php';

$lang_code = $_SESSION['language'] ?? 'english';
require_once "languages/$lang_code.php";

$result = $conn->query("SELECT * FROM users ORDER BY id DESC");
?>

<?php include 'header.php'; ?>

<div class="main-content p-4" style="flex: 1;">
    <h2 class="mb-4"><?= $lang['users'] ?></h2>
<?php if (isset($_GET['msg']) && $_GET['msg'] === 'deleted'): ?>
    <div class="alert alert-success"><?= $lang['user_deleted'] ?></div>
<?php endif; ?>

    <div class="table-responsive">
        <table class="table table-bordered bg-white">
            <thead class="table-secondary">
                <tr>
                    <th>#</th>
                    <th><?= $lang['name'] ?></th>
                    <th><?= $lang['email'] ?></th>
                    <th><?= $lang['actions'] ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $i = 1; while ($row = $result->fetch_assoc()): ?>
                    <tr>
<td><?= $row['id'] ?></td>
                        <td><?= htmlspecialchars($row['name']) ?></td>
                        <td><?= htmlspecialchars($row['email']) ?></td>
<td>
    <a href="edit_user.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning"><?= $lang['edit'] ?></a>

    <?php if ($user_id == 1 && $row['id'] != 1): ?>
        <a href="delete_user.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-danger"
           onclick="return confirm('<?= $lang['delete'] ?>')">
           <?= $lang['delete'] ?>
        </a>
    <?php endif; ?>
</td>

                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
