<?php
ob_start();
require_once 'config/config.php';
require_once __DIR__ . '/vendor/autoload.php';

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Invalid voucher ID.");
}

$id = intval($_GET['id']);

$stmt = $conn->prepare("SELECT * FROM vouchers WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    die("Voucher not found.");
}

$data = $result->fetch_assoc();

// جلب اسم المستخدم من جدول users
$prepared_by = 'User'; // القيمة الافتراضية

if (!empty($data['entered_by'])) {
    $user_id = (int) $data['entered_by'];

    $stmt = $conn->prepare("SELECT name FROM users WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($user = $result->fetch_assoc()) {
        $prepared_by = htmlspecialchars($user['name']);
    }
}


$mpdf = new \Mpdf\Mpdf([
    'mode' => 'utf-8',
    'format' => 'A4',
    'margin_top' => 0,
    'margin_bottom' => 0,
    'margin_left' => 0,
    'margin_right' => 0,
    'default_font' => 'dejavusans'
]);


$download_url = 'https://m-emp.com/bebek/generate_pdf.php?id=' . $id;

// إنشاء كود QR بصيغة HTML
$qr_code_html = '<barcode code="' . $download_url . '" type="QR" size="1" error="M" disableborder="true" class="qr-code" />';

$html = '
<style>
    @page {
        margin: 0;
    }
    body {
        font-family: dejavusans;
        font-size: 12pt;
        margin: 0;
        padding: 0;
    }
    .page-wrapper {
        position: relative;
        width: 100%;
        height: 100vh;
        overflow: hidden;
    }
    .header-img {
        width: 100%;
        height: auto;
        display: block;
    }
    .footer-img {
        width: 100%;
        position: absolute;
        bottom: 0;
        left: 0;
    }
    .voucher-content {
        padding: 0px 20px 50px 20px;
        box-sizing: border-box;
        position: relative;
        z-index: 10;
    }
    .header {
        text-align: center;
        font-weight: bold;
        font-size: 14pt;
        margin-bottom: 20px;
    }
    .section-title {
        font-weight: bold;
        font-size: 12pt;
        margin-top: 25px;
        margin-bottom: 10px;
        color: #333;
    }
    .info-table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 15px;
    }
    .info-table td {
        padding: 10px;
        border: 1px solid #ccc;
        text-align: left;
        vertical-align: top;
    }
    .main-table {
        width: 100%;
        border-collapse: collapse;
    }
    .main-table th {
        background-color: #f0f0f0;
        font-weight: bold;
        border: 1px solid #999;
        padding: 8px;
        font-size: 10pt;
    }
    .main-table td {
        border: 1px solid #999;
        padding: 8px;
        font-size: 10pt;
    }
    .terms-box {
        margin-top: 10px;
        padding: 10px;
        background-color: #f9f9f9;
        border: 1px dashed #aaa;
        white-space: pre-wrap;
        font-size: 10pt;
    }
    .signature {
        font-size: 10pt;
        border-top: 1px solid #000;
        width: 260px;
        padding-top: 5px;
        margin-top: 20px;
        text-align: left;
    }
    
    
    
    .hotel-table {
    width: 100%;
    border-collapse: collapse;
    margin-bottom: 15px;
}
.hotel-table th {
    background-color: #f0f0f0;
    font-weight: bold;
    border: 1px solid #999;
    padding: 8px;
    font-size: 10pt;
}
.hotel-table td {
    border: 1px solid #999;
    padding: 8px;
    font-size: 10pt;
    text-align: center;
    vertical-align: middle;
}
.qr-code {
    display: inline-block;
    padding: 2px;
    background: #ffffff;
    border: 1.5px solid #3A5F87; /* لون من الهوية البصرية */
    border-radius: 6px;
    box-shadow: 0 0 3px rgba(0, 0, 0, 0.1);
    margin-bottom: 10px;
    width: auto;
}



</style>

<div class="page-wrapper">
    <img src="images/header.png" class="header-img" />

    <div class="voucher-content">
    <div style="text-align:center; margin-top: 0px;">' . $qr_code_html . '</div>

        <div class="header">Bebek Travel & Tourism Hotels Operation and Management</div>

        <table width="100%" class="info-table">
            <tr>
                <td><strong>Date:</strong><br>' . htmlspecialchars($data['voucher_date'] ?? '') . '</td>
<td><strong>Status:</strong><br>' . htmlspecialchars($data['status'] ?? '') . '</td>
                <td><strong>Guest Name:</strong><br>' . htmlspecialchars($data['customer_name'] ?? '') . '</td>
                <td><strong>Booking Ref:</strong><br>' . htmlspecialchars($data['booking_number'] ?? '') . '</td>
            </tr>
        </table>


<div class="section-title">Hotel Details</div>
<table class="hotel-table">
    <thead>
        <tr>
            <th>Hotel</th>
            <th>City</th>
             <th>Confirmation Number</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>' . htmlspecialchars($data['hotel_name'] ?? '') . '</td>
            <td>' . htmlspecialchars($data['city'] ?? '') . '</td>
                        <td>' . htmlspecialchars($data['hotel_confirmation_number'] ?? '') . '</td>

            
        </tr>
    </tbody>
</table>

        <div class="section-title">Reservation Details</div>
        <table class="main-table">
            <thead>
                <tr>

                    <th>Room Type</th>
                    <th>View</th>
<th>Level</th>
<th>Meal</th>
                    <th>Rooms</th>
                    <th>Guests</th>
                    <th>Check In</th>
                    <th>Nts</th>
                    <th>Check Out</th>
                </tr>
            </thead>
            <tbody>
                <tr>

                    <td>' . htmlspecialchars($data['room_type'] ?? '') . '</td>
                    <td>' . htmlspecialchars($data['view'] ?? '') . '</td>
<td>' . htmlspecialchars($data['room_level'] ?? '') . '</td>
<td>' . htmlspecialchars($data['meal_plan'] ?? '') . '</td>

                    <td>' . htmlspecialchars($data['rooms_count'] ?? '') . '</td>
                    <td>' . htmlspecialchars($data['guests_per_room'] ?? '') . '</td>
                    <td>' . htmlspecialchars($data['check_in_date'] ?? '') . '</td>
                    <td>' . htmlspecialchars($data['nights'] ?? '') . '</td>
                    <td>' . htmlspecialchars($data['check_out_date'] ?? '') . '</td>
                </tr>
            </tbody>
        </table>

        <div class="section-title">Terms & Conditions</div>
        <div class="terms-box">' . nl2br(htmlspecialchars($data['terms'] ?? '')) . '</div>
<div class="signature">Prepared By: ' . $prepared_by . '</div>
    </div>

    <img src="images/footer.png" class="footer-img" />
</div>
';

$mpdf->WriteHTML($html);
ob_end_clean();
$mpdf->Output('voucher_' . preg_replace('/[^A-Za-z0-9_\-]/', '', $data['booking_number']) . '.pdf', 'I');
?>
---

هل ترغب بتوسيط التوقيع أو جعله على اليمين مثلاً بدل اليسار؟
