<?php
require_once 'config/config.php';
session_start();

$lang_code = $_SESSION['language'] ?? 'english';
require_once "languages/$lang_code.php";

// التحقق من تسجيل الدخول
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$user_id_to_edit = $_GET['id'] ?? null;
if (!$user_id_to_edit) {
    echo "<div class='alert alert-danger'>Invalid User ID</div>";
    exit;
}

$stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
$stmt->bind_param("i", $user_id_to_edit);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if (!$user) {
    echo "<div class='alert alert-danger'>User not found.</div>";
    exit;
}

$message = '';
$email_prefix = explode('@', $user['email'])[0];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $email_prefix = trim($_POST['email']);
    $email = $email_prefix . '@bebektravel.com';

    // تحديث الاسم والبريد
    $stmt = $conn->prepare("UPDATE users SET name = ?, email = ? WHERE id = ?");
    $stmt->bind_param("ssi", $name, $email, $user_id_to_edit);
    $stmt->execute();

    // تحديث كلمة المرور إذا تم إدخالها
    if (!empty($_POST['password'])) {
        $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $stmt = $conn->prepare("UPDATE users SET password = ? WHERE id = ?");
        $stmt->bind_param("si", $password, $user_id_to_edit);
        $stmt->execute();
    }

    $message = "<div class='alert alert-success'>{$lang['updated_successfully']}</div>";
    $user['name'] = $name;
    $user['email'] = $email;
}
?>

<?php include 'header.php'; ?>

<div class="main-content p-4" style="flex: 1;">
    <h3 class="mb-4"><?= $lang['edit_user'] ?></h3>
    <?= $message ?>

    <form method="POST" class="row g-3">
        <div class="col-md-6">
            <label class="form-label"><?= $lang['name'] ?></label>
            <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($user['name']) ?>" required>
        </div>

        <div class="col-md-6">
            <label class="form-label"><?= $lang['email'] ?></label>
            <div class="input-group">
                <input type="text" name="email" class="form-control" value="<?= htmlspecialchars($email_prefix) ?>" required>
                <span class="input-group-text">@bebektravel.com</span>
            </div>
        </div>

        <div class="col-12">
            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="togglePassword">
                <label class="form-check-label" for="togglePassword"><?= $lang['change_password'] ?></label>
            </div>
        </div>

        <div class="col-md-6" id="passwordField" style="display: none;">
            <label class="form-label"><?= $lang['password'] ?></label>
            <input type="password" name="password" class="form-control">
        </div>

        <div class="col-12">
            <button type="submit" class="btn btn-primary"><?= $lang['save_user'] ?></button>
        </div>
    </form>
</div>

<script>
document.getElementById('togglePassword').addEventListener('change', function () {
    const passwordField = document.getElementById('passwordField');
    if (this.checked) {
        passwordField.style.display = 'block';
    } else {
        passwordField.style.display = 'none';
    }
});
</script>

<?php include 'includes/footer.php'; ?>
