<?php
require_once 'config/config.php';
session_start();

// تحقق من صلاحية الدخول
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$success = '';
$error = '';

// تحديث الشروط في حال تم إرسال النموذج
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_terms = trim($_POST['terms']);

    if (!empty($new_terms)) {
        $stmt = $conn->prepare("UPDATE terms_conditions SET content = ? LIMIT 1");
        $stmt->bind_param("s", $new_terms);
        if ($stmt->execute()) {
            $success = "Terms & Conditions updated successfully.";
        } else {
            $error = "Failed to update terms.";
        }
    } else {
        $error = "Terms & Conditions cannot be empty.";
    }
}

// جلب الشروط الحالية من قاعدة البيانات
$current_terms = '';
$result = $conn->query("SELECT content FROM terms_conditions LIMIT 1");
if ($result && $result->num_rows > 0) {
    $current_terms = $result->fetch_assoc()['content'];
}

include 'header.php';
?>
<div class="main-content p-4" style="flex: 1;">

<h2 class="mb-4">Edit Terms & Conditions</h2>

<?php if ($success): ?>
    <div class="alert alert-success"><?= $success ?></div>
<?php elseif ($error): ?>
    <div class="alert alert-danger"><?= $error ?></div>
<?php endif; ?>

<form method="POST">
    <div class="mb-3">
        <label class="form-label">Terms & Conditions</label>
        <textarea name="terms" class="form-control" rows="12" required><?= htmlspecialchars($current_terms) ?></textarea>
    </div>
    <button type="submit" class="btn btn-primary">Save Changes</button>
</form>
</div> <!-- Close main-content -->

<?php include 'includes/footer.php'; ?>
